/*
 * Decompiled with CFR 0.152.
 */
package com.cyvack.crystal_clear.common.util;

import com.cyvack.crystal_clear.common.util.CasingHolder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;

public class GlassBlockList<T extends Block> {
    public Map<String, BlockEntry<T>> blockEntryMap = new HashMap<String, BlockEntry<T>>();

    public GlassBlockList(List<CasingHolder> holders, Function<CasingHolder, BlockEntry<T>> filler) {
        for (CasingHolder casing : holders) {
            this.blockEntryMap.put(casing.name(), filler.apply(casing));
        }
    }

    public BlockEntry<T>[] toArray() {
        BlockEntry[] blockEntries = new BlockEntry[this.blockEntryMap.size()];
        int i = 0;
        Iterator<BlockEntry<T>> iterator = this.blockEntryMap.values().iterator();
        while (iterator.hasNext()) {
            BlockEntry<T> value;
            blockEntries[i] = value = iterator.next();
            ++i;
        }
        return blockEntries;
    }

    public Block getCasing(String casingName) {
        return (Block)this.blockEntryMap.get(casingName).get();
    }
}

